/*
Copyright 2022 ojthetiny

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "samxeclipse.h"

led_config_t g_led_config = {{
    
    {NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED},
    {NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED,NO_LED},
    {NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, 0, 1, 2},
    {NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED},
    {NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED, NO_LED}
    },
    {
        {128, 220},{128, 230},{128, 250}
    },
    { 8,8,8}
};
bool rgb_matrix_indicators_advanced_user(uint8_t led_min, uint8_t led_max) {
    for (uint8_t i = led_min; i < led_max; i++) {
        //change the first and second value of those 3 HSV data types in order to change HUE and Saturation respectively. Maintain matrix_HSV.v so the colour will grab the brightness of VIAL setting dynamically.
        HSV matrix_HSV = rgb_matrix_get_hsv();
        HSV layer_1_HSV = {21,255,matrix_HSV.v};        //orange 
        HSV layer_2_HSV = {127, 255, matrix_HSV.v};     //cyan
        HSV layer_3_HSV = {180,255,matrix_HSV.v};       //purple
        RGB layer_1_colour = hsv_to_rgb(layer_1_HSV);
        RGB layer_2_colour = hsv_to_rgb(layer_2_HSV);
        RGB layer_3_colour = hsv_to_rgb(layer_3_HSV);

        //All 3 leds activate with the same colour for a single action and turn off otherwise
        if (host_keyboard_led_state().caps_lock) {  
            HSV hsv = rgb_matrix_get_hsv();
            RGB rgb = hsv_to_rgb(hsv);
            //leds turn on of the solid colour selected
            rgb_matrix_set_color(0, rgb.r,rgb.g,rgb.b);
            rgb_matrix_set_color(1, rgb.r,rgb.g,rgb.b);
            rgb_matrix_set_color(2, rgb.r,rgb.g,rgb.b);
        }
        switch(get_highest_layer(layer_state|default_layer_state)) {
            case 3:
                layer_3_HSV.v = matrix_HSV.v;
                layer_3_colour = hsv_to_rgb(layer_3_HSV);
                rgb_matrix_set_color(0, layer_3_colour.r,layer_3_colour.g,layer_3_colour.b);
                rgb_matrix_set_color(1, layer_3_colour.r,layer_3_colour.g,layer_3_colour.b);
                rgb_matrix_set_color(2, layer_3_colour.r,layer_3_colour.g,layer_3_colour.b);
                break;
            case 2:
                layer_2_HSV.v = matrix_HSV.v;
                layer_2_colour = hsv_to_rgb(layer_2_HSV);
                rgb_matrix_set_color(0, layer_2_colour.r,layer_2_colour.g,layer_2_colour.b);
                rgb_matrix_set_color(1, layer_2_colour.r,layer_2_colour.g,layer_2_colour.b);
                rgb_matrix_set_color(2, layer_2_colour.r,layer_2_colour.g,layer_2_colour.b);
                break;
            case 1:
                layer_1_HSV.v = matrix_HSV.v;
                layer_1_colour = hsv_to_rgb(layer_1_HSV);
                rgb_matrix_set_color(0, layer_1_colour.r,layer_1_colour.g,layer_1_colour.b);
                rgb_matrix_set_color(1, layer_1_colour.r,layer_1_colour.g,layer_1_colour.b);
                rgb_matrix_set_color(2, layer_1_colour.r,layer_1_colour.g,layer_1_colour.b);
                break;
            default:
                break;
        }

        //One single LED lights up per action type, change the index between 0-2 to select which led turns on for each action
        
        //CAPS-LOCK set to index 0 so first led from left
        /*if (host_keyboard_led_state().caps_lock) {  
            HSV hsv = rgb_matrix_get_hsv();
            RGB rgb = hsv_to_rgb(hsv);
            //leds turn on of the solid colour selected on VIAL 
            rgb_matrix_set_color(0, rgb.r,rgb.g,rgb.b); 
        }

        //Layer selection set to index 1 so center led
        switch(get_highest_layer(layer_state|default_layer_state)) {
            case 3:
                layer_3_HSV.v = matrix_HSV.v;
                layer_3_colour = hsv_to_rgb(layer_3_HSV);
                rgb_matrix_set_color(1, layer_3_colour.r,layer_3_colour.g,layer_3_colour.b);    
                break;
            case 2:
                layer_2_HSV.v = matrix_HSV.v;
                layer_2_colour = hsv_to_rgb(layer_2_HSV);
                rgb_matrix_set_color(1, layer_2_colour.r,layer_2_colour.g,layer_2_colour.b);
                break;
            case 1:
                layer_1_HSV.v = matrix_HSV.v;
                layer_1_colour = hsv_to_rgb(layer_1_HSV);
                rgb_matrix_set_color(1, layer_1_colour.r,layer_1_colour.g,layer_1_colour.b);
                break;
            default:
                break;
        }
        //Scroll-Lock selection set to index 2 so last led from left
        if(host_keyboard_led_state().scroll_lock){
            HSV hsv = rgb_matrix_get_hsv();
            RGB rgb = hsv_to_rgb(hsv);
            //led turns on of solid colour selected on VIAL 
            rgb_matrix_set_color(2, rgb.r,rgb.g,rgb.b);
        }*/
        

    

    }
    
    return false;
}